<?php
namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Crypt;
use Illuminate\Support\Facades\Http;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\Log;

class InitializeController extends Controller
{
    public function verify(Request $request)
    {
        $d = \Request::getHost();
        $domain = str_replace("www.", "", $d);

        $alldata = [
            'app_id' => "24626244",
            'ip' => $request->ip(),
            'domain' => $domain,
            'code' => $request->code
        ];

        Log::info('Verification started', $alldata);

        $data = $this->make_request($alldata);

        if ($data['status'] == 1) {
            Log::info('License verification successful', $data);

            file_put_contents(public_path() . '/config.txt', 1);

            $status = Crypt::encrypt('complete');
            @file_put_contents(public_path() . '/step3.txt', $status);

            $draft = Crypt::encrypt('gotostep1');
            @file_put_contents(public_path() . '/draft.txt', $draft);

            return redirect()->route('db.setup');
        } elseif ($data['msg'] == 'Already Register') {
            Log::warning('License already registered', $data);
            return redirect()->route('verifylicense')->withErrors(['User is already registered']);
        } else {
            Log::error('License verification failed', $data);
            return back()->withErrors([$data['msg']]);
        }
    }

    public function make_request($alldata)
    {
        $filePath = public_path('token/token.json');

if (file_exists($filePath)) {
    Log::info("Token file found at {$filePath}");
    $fileContents = file_get_contents($filePath);
    $tokenData = json_decode($fileContents, true);

    if (isset($tokenData['encrypted_token'])) {
        $decryptedToken = Crypt::decryptString($tokenData['encrypted_token']);
        $decryptedToken = trim($decryptedToken, 's:32:"";');
        Log::info("Token decrypted successfully");
    } else {
        Log::warning("Encrypted token not found in token.json");
    }
} else {
    Log::error("Token file does not exist at {$filePath}");
}


        $code = $alldata['code'];
        $url = "https://api.envato.com/v3/market/author/sale?code={$code}";
        Log::info("Sending request to Envato API", ['url' => $url]);

        $ch = curl_init();
        curl_setopt_array($ch, [
            CURLOPT_URL => $url,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_TIMEOUT => 20,
            CURLOPT_HTTPHEADER => [
                "Authorization: Bearer {$decryptedToken}",
            ],
        ]);

        $response = curl_exec($ch);
        $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);

        Log::info("Envato API response", ['http_code' => $httpCode, 'response' => $response]);

        $result = json_decode($response, true);

        if ($httpCode == 200) {
            $lic_json = [
                'name' => request()->user_id,
                'code' => $alldata['code'],
                'type' => __('envato'),
                'domain' => $alldata['domain'],
                'lic_type' => __('regular'),
                'token' => $decryptedToken
            ];

            $file = json_encode($lic_json);
            $filename = 'license.json';
            Storage::disk('local')->put('/keys/' . $filename, $file);
            Log::info("License file saved to storage/keys/{$filename}");

            return [
                'msg' => 'License verification successful',
                'status' => '1'
            ];
        } else {
            Log::error("Envato API verification failed", ['status_code' => $httpCode, 'response' => $result]);
            return [
                'msg' => 'Verification failed',
                'status' => '0'
            ];
        }
    }
    
}
